/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.server.VWSecurityQueryResults;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class VWParticipantList
implements Serializable {
    private static final long serialVersionUID = 471L;
    public static final int LIST_USER = 1;
    public static final int LIST_GROUP = 2;
    public static final int LIST_USER_AND_GROUP = 3;
    protected static final String DELIM = String.valueOf(":");
    protected int bufferSize = 200;
    protected VWParticipant[] fetchedObjects = null;
    protected Long[] idList = null;
    protected int returnCount = 0;
    protected int fetchCount = 0;
    protected boolean queryIsOver = false;
    protected String lastRecord = null;
    protected int listNameType = 0;
    protected VWSession session = null;
    protected String NCHServerName = null;
    protected String NCHServerDomain = null;
    protected String NCHServerOrganization = null;
    protected String searchPattern = null;
    protected String domain = null;
    protected int searchType = 0;
    protected int sortType = 0;
    protected long rpcArgFlag = 0L;
    private boolean inMemory = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-22 22:06:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWParticipantList(VWSession theSession, int theBufferSize, int theListNameType, String theSearchPattern, String theDomain, int theSearchType, int theSortType, long theRpcArgFlag) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.listNameType = theListNameType;
        this.searchPattern = theSearchPattern;
        this.domain = theDomain;
        this.searchType = theSearchType;
        this.sortType = theSortType;
        this.rpcArgFlag = theRpcArgFlag;
        this.hasNext();
    }

    protected VWParticipantList(VWParticipant[] theList) {
        this.inMemory = true;
        this.fetchedObjects = theList;
        this.queryIsOver = true;
        this.fetchCount = theList == null ? 0 : theList.length;
        this.returnCount = 0;
    }

    public void resetFetch() {
        if (this.inMemory) {
            this.returnCount = 0;
            return;
        }
        this.queryIsOver = false;
        this.lastRecord = null;
        this.fetchedObjects = null;
        this.returnCount = 0;
        this.fetchCount = 0;
    }

    public Object next() throws VWException {
        VWParticipant result = null;
        if (this.fetchCount == this.returnCount) {
            this.dofetch();
        }
        if (this.fetchCount != 0) {
            result = this.fetchedObjects[this.returnCount];
            ++this.returnCount;
        }
        return result;
    }

    protected void dofetch() throws VWException {
        if (this.fetchCount == this.returnCount) {
            this.returnCount = 0;
            this.fetchCount = 0;
            if (!this.queryIsOver) {
                VWSecurityQueryResults qresult;
                this.session.checkSession();
                if (this.NCHServerName == null) {
                    this.getNCHServerValues();
                }
                if ((qresult = this.session.getCmdSession().fetchUserList(this.bufferSize, this.listNameType, this.lastRecord, this.searchPattern, this.domain, this.searchType, this.sortType, this.rpcArgFlag | 0x10000L)) != null) {
                    this.fetchedObjects = qresult.fetchedObjects;
                    if (this.fetchedObjects != null) {
                        if (this.session.getCmdSession().getSecurityType() < 1) {
                            for (int i = 0; i < qresult.fetchedObjects.length; ++i) {
                                this.fetchedObjects[i].setParticipantName(this.session.stripOrgAndDomain(this.fetchedObjects[i].getParticipantName()));
                                this.fetchedObjects[i].setCommandSession(this.session.cmdSession);
                            }
                        } else {
                            for (int i = 0; i < qresult.fetchedObjects.length; ++i) {
                                this.fetchedObjects[i].setCommandSession(this.session.cmdSession);
                            }
                        }
                    }
                    this.lastRecord = qresult.lastRecord;
                    this.queryIsOver = qresult.queryIsOver;
                    this.idList = qresult.idList;
                }
            }
            if (this.fetchedObjects != null) {
                this.fetchCount = this.fetchedObjects.length;
            }
        }
    }

    public boolean hasNext() throws VWException {
        boolean result = true;
        if (!(this.queryIsOver || this.fetchCount != 0 && this.returnCount != this.fetchCount)) {
            this.dofetch();
        }
        if (this.queryIsOver && this.returnCount == this.fetchCount) {
            result = false;
        }
        return result;
    }

    protected void getNCHServerValues() throws VWException {
        try {
            StringTokenizer stmp;
            if (this.NCHServerName == null && this.session != null) {
                this.NCHServerName = this.session.getNCHServerName();
            }
            if (this.NCHServerName != null && (stmp = new StringTokenizer(this.NCHServerName, DELIM, false)).hasMoreTokens()) {
                String tmpName = stmp.nextToken();
                if (stmp.hasMoreTokens()) {
                    this.NCHServerDomain = stmp.nextToken();
                    if (stmp.hasMoreTokens()) {
                        this.NCHServerOrganization = stmp.nextToken();
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof VWException) {
                throw (VWException)ex;
            }
            this.NCHServerName = null;
            this.NCHServerDomain = "FileNetDomain";
            this.NCHServerOrganization = "FileNet";
            return;
        }
    }

    public String toString() {
        String theString = "";
        String separator = ",";
        if (this.fetchedObjects != null && this.fetchedObjects.length > 0) {
            theString = this.fetchedObjects[0].getParticipantName();
            for (int i = 1; i < this.fetchedObjects.length; ++i) {
                theString = theString + separator + this.fetchedObjects[i].getParticipantName();
            }
        } else {
            theString = null;
        }
        return theString;
    }
}

